SELECT * FROM (
WITH NUMERO_ESTUDIANTES AS ( SELECT SFRSTCR_TERM_CODE TERM_CODE, SFRSTCR_CRN NRC, COUNT(SFRSTCR_PIDM) NUMERO_ESTUDIANTES 
                             FROM SFRSTCR 
                             WHERE SFRSTCR_RSTS_CODE IN('RM','RE','RW','MF','MA') 
                             GROUP BY SFRSTCR_TERM_CODE, SFRSTCR_CRN )
                            
SELECT 
SUBSTR(CT.SSBSECT_TERM_CODE,1,4) AS ANIO,
CT.SSBSECT_TERM_CODE AS PERIODO_CODIGO,
CT.SSBSECT_SUBJ_CODE,
SSBSECT_CRSE_NUMB,
CASE 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 10 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 60 THEN '2'
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 30 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 80 THEN '2' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 00 THEN '3' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 50 THEN '4' 
    ELSE NULL 
END AS SEMESTRE,
CT.SSBSECT_CRN AS NRC,
CT.SSBSECT_SSTS_CODE AS STATUS_NRC,
CT.SSBSECT_CAMP_CODE AS CIUDAD_CODIGO_NRC,
CASE 
     WHEN CT.SSBSECT_CAMP_CODE = 'VIR' THEN 'VIRTUAL' 
     ELSE 'PRESENCIAL' 
END AS MODALIDAD_NRC,
CASE 
     WHEN CT.SSBSECT_SESS_CODE = 'V' THEN 'VIRTUAL'
     WHEN CT.SSBSECT_SESS_CODE = 'D' THEN 'DIURNO'
     WHEN CT.SSBSECT_SESS_CODE = 'N' THEN 'NOCTURNO'
     ELSE CT.SSBSECT_SESS_CODE 
END AS JORNADA_NRC,
--TTR.SSRATTR_ATTR_CODE AS ATRIBUTO_NRC,
CT.SSBSECT_SUBJ_CODE||CT.SSBSECT_CRSE_NUMB AS CODIGO_MATERIA_NRC,
T1.SCBCRSE_TITLE AS NOMBRE_MATERIA_NRC,                 
L1.SCRLEVL_LEVL_CODE AS NIVEL_MATERIA,
COLL.STVCOLL_DESC AS FACULTAD_MATERIA,
A.STVDEPT_DESC AS ESCUELA_PROFESOR,
MEET.SSRMEET_START_DATE AS INICIO_NRC,
MEET.SSRMEET_END_DATE AS FIN_NRC,
CASE 
     WHEN MEET.SSRMEET_BEGIN_TIME IS NOT NULL 
     THEN SUBSTR(MEET.SSRMEET_BEGIN_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_BEGIN_TIME,3,2) ELSE NULL 
END AS HORA_INICIO_NRC,
CASE 
     WHEN MEET.SSRMEET_END_TIME IS NOT NULL
     THEN SUBSTR(MEET.SSRMEET_END_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_END_TIME,3,2) ELSE NULL 
END AS HORA_FIN_NRC,
CASE 
    WHEN MEET.SSRMEET_MON_DAY = 'M' THEN 'LUNES'    
    WHEN MEET.SSRMEET_MON_DAY = 'L' THEN 'LUNES'   
END AS DIA,
MEET.SSRMEET_HRS_WEEK AS HORAS_SEMANALES_NRC,
CT.SSBSECT_PTRM_WEEKS * MEET.SSRMEET_HRS_WEEK AS HORAS_SEMESTRE,
T1.HR_LOW AS CREDITOS_MATERIA_NRC,--SSBSECT_CREDIT_HRS -- SSRMEET_CREDIT_HR_SESS 
T1.LEC_HR_LOW AS INTENSIDAD_HORARIA,
MEET.SSRMEET_MTYP_CODE AS TIPO_CLASE_NRC,
MEET.SSRMEET_BLDG_CODE AS BLOQUE_NRC,
MEET.SSRMEET_ROOM_CODE AS SALON_NRC,
DEF.SLBRDEF_CAPACITY AS CAPACIDAD_SALON,                
CT.SSBSECT_PTRM_CODE,  
CT.SSBSECT_MAX_ENRL,  
CT.SSBSECT_ENRL,    
CT.SSBSECT_SEATS_AVAIL,                          
SPRI.SPRIDEN_ID AS ID_DOCENTE,
SPRI.SPRIDEN_LAST_NAME AS Apellido_Docente,
SPRI.SPRIDEN_FIRST_NAME AS Nombre_Docente,
GOBTPAC_EXTERNAL_USER AS USUARIO_DOCENTE,
CASE 
    WHEN DOCENTE.SIRASGN_PRIMARY_IND = 'Y' 
    THEN 'SI' ELSE 'NO' 
END INDICADOR_PRINCIPAL,
NUMERO_ESTUDIANTES.NUMERO_ESTUDIANTES,
SLRRDEF.SLRRDEF_RDEF_CODE AS TIPO_SALON,                 
SOBPTRM_START_DATE AS FECHA_INICIO, 
SOBPTRM_END_DATE AS FECHA_FIN,
SPBPERS_SSN AS DOCUMEN_PROFESOR
FROM SSBSECT CT 
LEFT JOIN (SELECT 
           SE1.SCBCRSE_SUBJ_CODE AS SUBJ, 
           SE1.SCBCRSE_CRSE_NUMB AS CRSE,
           SE1.SCBCRSE_CREDIT_HR_LOW AS HR_LOW,
           SE1.SCBCRSE_LEC_HR_LOW AS LEC_HR_LOW,
           SE1.SCBCRSE_TITLE AS SCBCRSE_TITLE,
           SE1.SCBCRSE_COLL_CODE AS SCBCRSE_COLL_CODE,
           SE1.SCBCRSE_DEPT_CODE AS SCBCRSE_DEPT_CODE
           FROM SCBCRSE SE1 
           WHERE SE1.SCBCRSE_SURROGATE_ID= (SELECT MAX(SE2.SCBCRSE_SURROGATE_ID) 
                                            FROM SCBCRSE SE2 
                                            WHERE SE1.SCBCRSE_SUBJ_CODE||SE1.SCBCRSE_CRSE_NUMB = SE2.SCBCRSE_SUBJ_CODE||SE2.SCBCRSE_CRSE_NUMB)) T1 ON t1.subj = CT.SSBSECT_SUBJ_CODE AND T1.CRSE = CT.SSBSECT_CRSE_NUMB
LEFT JOIN STVCOLL COLL ON COLL.STVCOLL_CODE = T1.SCBCRSE_COLL_CODE
LEFT OUTER JOIN SIRASGN DOCENTE ON DOCENTE.SIRASGN_TERM_CODE = CT.SSBSECT_TERM_CODE AND DOCENTE.SIRASGN_CRN = CT.SSBSECT_CRN
LEFT OUTER JOIN SPRIDEN SPRI ON SPRI.SPRIDEN_PIDM = SIRASGN_PIDM
LEFT JOIN STVDEPT A ON A.STVDEPT_CODE = T1.SCBCRSE_DEPT_CODE
LEFT JOIN SSRMEET MEET ON MEET.SSRMEET_TERM_CODE = CT.SSBSECT_TERM_CODE AND MEET.SSRMEET_CRN = CT.SSBSECT_CRN
LEFT JOIN SSRATTR TTR ON TTR.SSRATTR_TERM_CODE = MEET.SSRMEET_TERM_CODE AND TTR.SSRATTR_CRN = MEET.SSRMEET_CRN
LEFT JOIN SLBRDEF DEF ON DEF.SLBRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND DEF.SLBRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE AND SLBRDEF_RMST_CODE = 'AC'
LEFT JOIN NUMERO_ESTUDIANTES ON TERM_CODE = MEET.SSRMEET_TERM_CODE  AND NRC = MEET.SSRMEET_CRN
LEFT JOIN (SELECT LVL.SCRLEVL_SUBJ_CODE,LVL.SCRLEVL_CRSE_NUMB,LVL.SCRLEVL_LEVL_CODE 
           FROM SCRLEVL LVL 
           WHERE LVL.SCRLEVL_SURROGATE_ID = (SELECT MAX(LV.SCRLEVL_SURROGATE_ID)
                                            FROM SCRLEVL LV 
                                            WHERE LV.SCRLEVL_SUBJ_CODE =LVL.SCRLEVL_SUBJ_CODE 
                                            AND LV.SCRLEVL_CRSE_NUMB = LVL.SCRLEVL_CRSE_NUMB)) L1 ON L1.SCRLEVL_SUBJ_CODE=CT.SSBSECT_SUBJ_CODE AND L1.SCRLEVL_CRSE_NUMB=CT.SSBSECT_CRSE_NUMB 
LEFT JOIN GOBTPAC ON GOBTPAC_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN SPBPERS ON SPBPERS_PIDM = SPRI.SPRIDEN_PIDM
LEFT JOIN (SELECT
           SLRRDEF_BLDG_CODE, 
           SLRRDEF_ROOM_NUMBER, 
           SLRRDEF_RDEF_CODE
           FROM SLRRDEF SL
           WHERE SLRRDEF_SURROGATE_ID = (SELECT MAX(SLRRDEF_SURROGATE_ID) 
                                         FROM SLRRDEF  SL1
                                         WHERE SL.SLRRDEF_BLDG_CODE = SL1.SLRRDEF_BLDG_CODE
                                         AND SL.SLRRDEF_ROOM_NUMBER = SL1.SLRRDEF_ROOM_NUMBER)) SLRRDEF ON SLRRDEF.SLRRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND SLRRDEF.SLRRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE 
LEFT JOIN SOBPTRM ON SOBPTRM_TERM_CODE=CT.SSBSECT_TERM_CODE AND SOBPTRM_PTRM_CODE = CT.SSBSECT_PTRM_CODE
WHERE CT.SSBSECT_TERM_CODE >='202460' 
AND CT.SSBSECT_TERM_CODE <='9999' 
AND SPRIDEN_CHANGE_IND is null 
AND (SSRMEET_MON_DAY = 'M' OR SSRMEET_MON_DAY = 'L')

UNION 
SELECT * FROM (
WITH NUMERO_ESTUDIANTES AS (SELECT SFRSTCR_TERM_CODE TERM_CODE, SFRSTCR_CRN NRC, COUNT(SFRSTCR_PIDM) NUMERO_ESTUDIANTES FROM SFRSTCR GROUP BY SFRSTCR_TERM_CODE, SFRSTCR_CRN)

SELECT 
SUBSTR(CT.SSBSECT_TERM_CODE,1,4) AS ANIO,
CT.SSBSECT_TERM_CODE AS PERIODO_CODIGO,
CT.SSBSECT_SUBJ_CODE,
SSBSECT_CRSE_NUMB,
CASE 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 10 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 60 THEN '2'
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 30 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 80 THEN '2' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 00 THEN '3' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 50 THEN '4' 
    ELSE NULL 
END AS SEMESTRE,
CT.SSBSECT_CRN AS NRC,
CT.SSBSECT_SSTS_CODE AS STATUS_NRC,
CT.SSBSECT_CAMP_CODE AS CIUDAD_CODIGO_NRC,
CASE 
     WHEN CT.SSBSECT_CAMP_CODE = 'VIR' 
     THEN 'VIRTUAL' ELSE 'PRESENCIAL' 
END AS MODALIDAD_NRC,
CASE 
     WHEN CT.SSBSECT_SESS_CODE = 'V' THEN 'VIRTUAL'
     WHEN CT.SSBSECT_SESS_CODE = 'D' THEN 'DIURNO'
     WHEN CT.SSBSECT_SESS_CODE = 'N' THEN 'NOCTURNO'
     ELSE CT.SSBSECT_SESS_CODE 
END AS JORNADA_NRC,
-- TTR.SSRATTR_ATTR_CODE AS ATRIBUTO_NRC,
CT.SSBSECT_SUBJ_CODE||CT.SSBSECT_CRSE_NUMB AS CODIGO_MATERIA_NRC,
T1.SCBCRSE_TITLE AS NOMBRE_MATERIA_NRC,                 
L1.SCRLEVL_LEVL_CODE AS NIVEL_MATERIA,
COLL.STVCOLL_DESC AS FACULTAD_MATERIA,
A.STVDEPT_DESC AS ESCUELA_PROFESOR,
MEET.SSRMEET_START_DATE AS INICIO_NRC,
MEET.SSRMEET_END_DATE AS FIN_NRC,
CASE 
    WHEN MEET.SSRMEET_BEGIN_TIME IS NOT NULL 
    THEN SUBSTR(MEET.SSRMEET_BEGIN_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_BEGIN_TIME,3,2) ELSE NULL 
END AS HORA_INICIO_NRC,
CASE 
    WHEN MEET.SSRMEET_END_TIME IS NOT NULL
    THEN SUBSTR(MEET.SSRMEET_END_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_END_TIME,3,2) ELSE NULL 
END AS HORA_FIN_NRC,
CASE 
    WHEN SSRMEET_FRI_DAY = 'F' 
    THEN 'VIERNES'                    
END AS DIA,
MEET.SSRMEET_HRS_WEEK AS HORAS_SEMANALES_NRC,
CT.SSBSECT_PTRM_WEEKS * MEET.SSRMEET_HRS_WEEK AS HORAS_SEMESTRE,
T1.HR_LOW AS CREDITOS_MATERIA_NRC,--SSBSECT_CREDIT_HRS -- SSRMEET_CREDIT_HR_SESS 
T1.LEC_HR_LOW AS INTENSIDAD_HORARIA,
MEET.SSRMEET_MTYP_CODE AS TIPO_CLASE_NRC,
MEET.SSRMEET_BLDG_CODE AS BLOQUE_NRC,
MEET.SSRMEET_ROOM_CODE AS SALON_NRC,
DEF.SLBRDEF_CAPACITY AS CAPACIDAD_SALON,
CT.SSBSECT_PTRM_CODE,  
CT.SSBSECT_MAX_ENRL,  
CT.SSBSECT_ENRL,    
CT.SSBSECT_SEATS_AVAIL,                          
SPRI.SPRIDEN_ID AS ID_DOCENTE,
SPRI.SPRIDEN_LAST_NAME AS Apellido_Docente,
SPRI.SPRIDEN_FIRST_NAME AS Nombre_Docente,
GOBTPAC_EXTERNAL_USER AS USUARIO_DOCENTE,
CASE 
    WHEN DOCENTE.SIRASGN_PRIMARY_IND = 'Y' 
    THEN 'SI' ELSE 'NO' 
END INDICADOR_PRINCIPAL,
NUMERO_ESTUDIANTES.NUMERO_ESTUDIANTES,
SLRRDEF.SLRRDEF_RDEF_CODE AS TIPO_SALON,                 
SOBPTRM_START_DATE AS FECHA_INICIO, 
SOBPTRM_END_DATE AS FECHA_FIN,
SPBPERS_SSN AS DOCUMEN_PROFESOR
FROM SSBSECT CT 
LEFT JOIN (SELECT 
           SE1.SCBCRSE_SUBJ_CODE AS SUBJ, 
           SE1.SCBCRSE_CRSE_NUMB AS CRSE,
           SE1.SCBCRSE_CREDIT_HR_LOW AS HR_LOW,
           SE1.SCBCRSE_LEC_HR_LOW AS LEC_HR_LOW,
           SE1.SCBCRSE_TITLE AS SCBCRSE_TITLE,
           SE1.SCBCRSE_COLL_CODE AS SCBCRSE_COLL_CODE,
           SE1.SCBCRSE_DEPT_CODE AS SCBCRSE_DEPT_CODE
           FROM SCBCRSE SE1 
           WHERE SE1.SCBCRSE_SURROGATE_ID= (SELECT MAX(SE2.SCBCRSE_SURROGATE_ID) 
                                            FROM SCBCRSE SE2 
                                            WHERE SE1.SCBCRSE_SUBJ_CODE||SE1.SCBCRSE_CRSE_NUMB = SE2.SCBCRSE_SUBJ_CODE||SE2.SCBCRSE_CRSE_NUMB)) T1 ON t1.subj = CT.SSBSECT_SUBJ_CODE AND T1.CRSE = CT.SSBSECT_CRSE_NUMB
LEFT JOIN STVCOLL COLL ON COLL.STVCOLL_CODE = T1.SCBCRSE_COLL_CODE
LEFT OUTER JOIN SIRASGN DOCENTE ON DOCENTE.SIRASGN_TERM_CODE = CT.SSBSECT_TERM_CODE AND DOCENTE.SIRASGN_CRN = CT.SSBSECT_CRN
LEFT OUTER JOIN SPRIDEN SPRI ON SPRI.SPRIDEN_PIDM = SIRASGN_PIDM
LEFT JOIN STVDEPT A ON A.STVDEPT_CODE = T1.SCBCRSE_DEPT_CODE
LEFT JOIN SSRMEET MEET ON MEET.SSRMEET_TERM_CODE = CT.SSBSECT_TERM_CODE AND MEET.SSRMEET_CRN = CT.SSBSECT_CRN
LEFT JOIN SSRATTR TTR ON TTR.SSRATTR_TERM_CODE = MEET.SSRMEET_TERM_CODE AND TTR.SSRATTR_CRN = MEET.SSRMEET_CRN
LEFT JOIN SLBRDEF DEF ON DEF.SLBRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND DEF.SLBRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE AND SLBRDEF_RMST_CODE = 'AC'
LEFT JOIN NUMERO_ESTUDIANTES ON TERM_CODE = MEET.SSRMEET_TERM_CODE  AND NRC = MEET.SSRMEET_CRN
LEFT JOIN (SELECT LVL.SCRLEVL_SUBJ_CODE,LVL.SCRLEVL_CRSE_NUMB,LVL.SCRLEVL_LEVL_CODE 
           FROM SCRLEVL LVL 
           WHERE LVL.SCRLEVL_SURROGATE_ID = (SELECT MAX(LV.SCRLEVL_SURROGATE_ID)
                                             FROM SCRLEVL LV 
                                             WHERE LV.SCRLEVL_SUBJ_CODE =LVL.SCRLEVL_SUBJ_CODE 
                                             AND LV.SCRLEVL_CRSE_NUMB = LVL.SCRLEVL_CRSE_NUMB)) L1 ON L1.SCRLEVL_SUBJ_CODE=CT.SSBSECT_SUBJ_CODE AND L1.SCRLEVL_CRSE_NUMB=CT.SSBSECT_CRSE_NUMB 
LEFT JOIN GOBTPAC ON GOBTPAC_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN SPBPERS ON SPBPERS_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN (SELECT
           SLRRDEF_BLDG_CODE, 
           SLRRDEF_ROOM_NUMBER, 
           SLRRDEF_RDEF_CODE
           FROM SLRRDEF SL
           WHERE SLRRDEF_SURROGATE_ID = (SELECT MAX(SLRRDEF_SURROGATE_ID) 
                                         FROM SLRRDEF  SL1
                                         WHERE SL.SLRRDEF_BLDG_CODE = SL1.SLRRDEF_BLDG_CODE
                                         AND SL.SLRRDEF_ROOM_NUMBER = SL1.SLRRDEF_ROOM_NUMBER)) SLRRDEF ON SLRRDEF.SLRRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND SLRRDEF.SLRRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE 
LEFT JOIN SOBPTRM ON SOBPTRM_TERM_CODE=CT.SSBSECT_TERM_CODE AND SOBPTRM_PTRM_CODE = CT.SSBSECT_PTRM_CODE
WHERE CT.SSBSECT_TERM_CODE >='202460' 
AND CT.SSBSECT_TERM_CODE <='9999' 
AND SPRIDEN_CHANGE_IND is null 
AND SSRMEET_FRI_DAY = 'F' )

UNION
SELECT * FROM (
WITH NUMERO_ESTUDIANTES AS (SELECT SFRSTCR_TERM_CODE TERM_CODE, SFRSTCR_CRN NRC, COUNT(SFRSTCR_PIDM) NUMERO_ESTUDIANTES FROM SFRSTCR WHERE SFRSTCR_RSTS_CODE IN('RM','RE','RW','MF','MA') GROUP BY SFRSTCR_TERM_CODE, SFRSTCR_CRN)

SELECT 
SUBSTR(CT.SSBSECT_TERM_CODE,1,4) AS ANIO,
CT.SSBSECT_TERM_CODE AS PERIODO_CODIGO,
CT.SSBSECT_SUBJ_CODE,
SSBSECT_CRSE_NUMB,
CASE 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 10 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 60 THEN '2'
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 30 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 80 THEN '2' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 00 THEN '3' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 50 THEN '4' 
    ELSE NULL 
END AS SEMESTRE,
CT.SSBSECT_CRN AS NRC,
CT.SSBSECT_SSTS_CODE STATUS_NRC,
CT.SSBSECT_CAMP_CODE AS CIUDAD_CODIGO_NRC,
CASE 
     WHEN CT.SSBSECT_CAMP_CODE = 'VIR' 
     THEN 'VIRTUAL' ELSE 'PRESENCIAL' 
END AS MODALIDAD_NRC,
CASE WHEN CT.SSBSECT_SESS_CODE = 'V' THEN 'VIRTUAL'
     WHEN CT.SSBSECT_SESS_CODE = 'D' THEN 'DIURNO'
     WHEN CT.SSBSECT_SESS_CODE = 'N' THEN 'NOCTURNO'
     ELSE CT.SSBSECT_SESS_CODE 
END AS JORNADA_NRC,
--TTR.SSRATTR_ATTR_CODE AS ATRIBUTO_NRC,
CT.SSBSECT_SUBJ_CODE||CT.SSBSECT_CRSE_NUMB AS CODIGO_MATERIA_NRC,
T1.SCBCRSE_TITLE AS NOMBRE_MATERIA_NRC,                 
L1.SCRLEVL_LEVL_CODE AS NIVEL_MATERIA,
COLL.STVCOLL_DESC AS FACULTAD_MATERIA,
A.STVDEPT_DESC AS ESCUELA_PROFESOR,
MEET.SSRMEET_START_DATE AS INICIO_NRC,
MEET.SSRMEET_END_DATE AS FIN_NRC,
CASE 
    WHEN MEET.SSRMEET_BEGIN_TIME IS NOT NULL 
    THEN SUBSTR(MEET.SSRMEET_BEGIN_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_BEGIN_TIME,3,2) ELSE NULL 
END AS HORA_INICIO_NRC,
CASE 
    WHEN MEET.SSRMEET_END_TIME IS NOT NULL
    THEN SUBSTR(MEET.SSRMEET_END_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_END_TIME,3,2) ELSE NULL 
END AS HORA_FIN_NRC,
CASE 
    WHEN MEET.SSRMEET_THU_DAY = 'R' THEN 'JUEVES' 
    WHEN MEET.SSRMEET_THU_DAY = 'J' THEN 'JUEVES'
END AS DIA,
MEET.SSRMEET_HRS_WEEK AS HORAS_SEMANALES_NRC,
CT.SSBSECT_PTRM_WEEKS * MEET.SSRMEET_HRS_WEEK AS HORAS_SEMESTRE,
T1.HR_LOW AS CREDITOS_MATERIA_NRC,--SSBSECT_CREDIT_HRS -- SSRMEET_CREDIT_HR_SESS 
T1.LEC_HR_LOW AS INTENSIDAD_HORARIA,
MEET.SSRMEET_MTYP_CODE AS TIPO_CLASE_NRC,
MEET.SSRMEET_BLDG_CODE AS BLOQUE_NRC,
MEET.SSRMEET_ROOM_CODE AS SALON_NRC,
DEF.SLBRDEF_CAPACITY AS CAPACIDAD_SALON,               
CT.SSBSECT_PTRM_CODE,  
CT.SSBSECT_MAX_ENRL,  
CT.SSBSECT_ENRL,    
CT.SSBSECT_SEATS_AVAIL,                          
SPRI.SPRIDEN_ID AS ID_DOCENTE,
SPRI.SPRIDEN_LAST_NAME AS Apellido_Docente,
SPRI.SPRIDEN_FIRST_NAME AS Nombre_Docente,
GOBTPAC_EXTERNAL_USER AS USUARIO_DOCENTE,
CASE 
    WHEN DOCENTE.SIRASGN_PRIMARY_IND = 'Y' 
    THEN 'SI' ELSE 'NO' 
END INDICADOR_PRINCIPAL,
NUMERO_ESTUDIANTES.NUMERO_ESTUDIANTES, 
SLRRDEF.SLRRDEF_RDEF_CODE AS TIPO_SALON,                 
SOBPTRM_START_DATE AS FECHA_INICIO, 
SOBPTRM_END_DATE AS FECHA_FIN,
SPBPERS_SSN AS DOCUMEN_PROFESOR
FROM SSBSECT CT 
LEFT JOIN (SELECT 
           SE1.SCBCRSE_SUBJ_CODE AS SUBJ, 
           SE1.SCBCRSE_CRSE_NUMB AS CRSE,
           SE1.SCBCRSE_CREDIT_HR_LOW AS HR_LOW,
           SE1.SCBCRSE_LEC_HR_LOW AS LEC_HR_LOW,
           SE1.SCBCRSE_TITLE AS SCBCRSE_TITLE,
           SE1.SCBCRSE_COLL_CODE AS SCBCRSE_COLL_CODE,
           SE1.SCBCRSE_DEPT_CODE AS SCBCRSE_DEPT_CODE
           FROM SCBCRSE SE1 
           WHERE SE1.SCBCRSE_SURROGATE_ID= (SELECT MAX(SE2.SCBCRSE_SURROGATE_ID) 
                                            FROM SCBCRSE SE2 
                                            WHERE SE1.SCBCRSE_SUBJ_CODE||SE1.SCBCRSE_CRSE_NUMB = SE2.SCBCRSE_SUBJ_CODE||SE2.SCBCRSE_CRSE_NUMB)) T1 ON t1.subj = CT.SSBSECT_SUBJ_CODE AND T1.CRSE = CT.SSBSECT_CRSE_NUMB
LEFT JOIN STVCOLL COLL ON COLL.STVCOLL_CODE = T1.SCBCRSE_COLL_CODE
LEFT OUTER JOIN SIRASGN DOCENTE ON DOCENTE.SIRASGN_TERM_CODE = CT.SSBSECT_TERM_CODE AND DOCENTE.SIRASGN_CRN = CT.SSBSECT_CRN
LEFT OUTER JOIN SPRIDEN SPRI ON SPRI.SPRIDEN_PIDM = SIRASGN_PIDM
LEFT JOIN STVDEPT A ON A.STVDEPT_CODE = T1.SCBCRSE_DEPT_CODE
LEFT JOIN SSRMEET MEET ON MEET.SSRMEET_TERM_CODE = CT.SSBSECT_TERM_CODE AND MEET.SSRMEET_CRN = CT.SSBSECT_CRN
LEFT JOIN SSRATTR TTR ON TTR.SSRATTR_TERM_CODE = MEET.SSRMEET_TERM_CODE AND TTR.SSRATTR_CRN = MEET.SSRMEET_CRN
LEFT JOIN SLBRDEF DEF ON DEF.SLBRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND DEF.SLBRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE AND SLBRDEF_RMST_CODE = 'AC'
LEFT JOIN NUMERO_ESTUDIANTES ON TERM_CODE = MEET.SSRMEET_TERM_CODE  AND NRC = MEET.SSRMEET_CRN
LEFT JOIN (SELECT LVL.SCRLEVL_SUBJ_CODE,LVL.SCRLEVL_CRSE_NUMB,LVL.SCRLEVL_LEVL_CODE 
           FROM SCRLEVL LVL 
           WHERE LVL.SCRLEVL_SURROGATE_ID = (SELECT MAX(LV.SCRLEVL_SURROGATE_ID)
                                             FROM SCRLEVL LV 
                                             WHERE LV.SCRLEVL_SUBJ_CODE =LVL.SCRLEVL_SUBJ_CODE 
                                             AND LV.SCRLEVL_CRSE_NUMB = LVL.SCRLEVL_CRSE_NUMB)) L1 ON L1.SCRLEVL_SUBJ_CODE=CT.SSBSECT_SUBJ_CODE AND L1.SCRLEVL_CRSE_NUMB=CT.SSBSECT_CRSE_NUMB 
LEFT JOIN GOBTPAC ON GOBTPAC_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN SPBPERS ON SPBPERS_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN (SELECT
           SLRRDEF_BLDG_CODE, 
           SLRRDEF_ROOM_NUMBER, 
           SLRRDEF_RDEF_CODE
           FROM SLRRDEF SL
           WHERE SLRRDEF_SURROGATE_ID = (SELECT MAX(SLRRDEF_SURROGATE_ID) 
                                         FROM SLRRDEF  SL1
                                         WHERE SL.SLRRDEF_BLDG_CODE = SL1.SLRRDEF_BLDG_CODE
                                         AND SL.SLRRDEF_ROOM_NUMBER = SL1.SLRRDEF_ROOM_NUMBER)) SLRRDEF ON SLRRDEF.SLRRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND SLRRDEF.SLRRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE 
LEFT JOIN SOBPTRM ON SOBPTRM_TERM_CODE=CT.SSBSECT_TERM_CODE AND SOBPTRM_PTRM_CODE = CT.SSBSECT_PTRM_CODE
WHERE CT.SSBSECT_TERM_CODE >='202460' 
AND CT.SSBSECT_TERM_CODE <='9999' 
AND SPRIDEN_CHANGE_IND is null  
AND (SSRMEET_THU_DAY = 'R' OR SSRMEET_THU_DAY = 'J'))

UNION 
SELECT * FROM (
WITH NUMERO_ESTUDIANTES AS (SELECT SFRSTCR_TERM_CODE TERM_CODE, SFRSTCR_CRN NRC, COUNT(SFRSTCR_PIDM) NUMERO_ESTUDIANTES FROM SFRSTCR WHERE SFRSTCR_RSTS_CODE IN('RM','RE','RW','MF','MA') GROUP BY SFRSTCR_TERM_CODE, SFRSTCR_CRN)

SELECT SUBSTR(
CT.SSBSECT_TERM_CODE,1,4) AS ANIO,
CT.SSBSECT_TERM_CODE AS PERIODO_CODIGO,
CT.SSBSECT_SUBJ_CODE,
SSBSECT_CRSE_NUMB,
CASE 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 10 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 60 THEN '2'
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 30 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 80 THEN '2' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 00 THEN '3' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 50 THEN '4' 
    ELSE NULL 
END AS SEMESTRE,
CT.SSBSECT_CRN AS NRC,
CT.SSBSECT_SSTS_CODE AS STATUS_NRC,
CT.SSBSECT_CAMP_CODE AS CIUDAD_CODIGO_NRC,
CASE 
     WHEN CT.SSBSECT_CAMP_CODE = 'VIR' 
     THEN 'VIRTUAL' ELSE 'PRESENCIAL' 
END AS MODALIDAD_NRC,
CASE 
     WHEN CT.SSBSECT_SESS_CODE = 'V' THEN 'VIRTUAL'
     WHEN CT.SSBSECT_SESS_CODE = 'D' THEN 'DIURNO'
     WHEN CT.SSBSECT_SESS_CODE = 'N' THEN 'NOCTURNO'
     ELSE CT.SSBSECT_SESS_CODE 
END AS JORNADA_NRC,
--TTR.SSRATTR_ATTR_CODE AS ATRIBUTO_NRC,
CT.SSBSECT_SUBJ_CODE||CT.SSBSECT_CRSE_NUMB AS CODIGO_MATERIA_NRC,
T1.SCBCRSE_TITLE AS NOMBRE_MATERIA_NRC,                 
L1.SCRLEVL_LEVL_CODE AS NIVEL_MATERIA,
COLL.STVCOLL_DESC AS FACULTAD_MATERIA,
A.STVDEPT_DESC AS ESCUELA_PROFESOR,
MEET.SSRMEET_START_DATE AS INICIO_NRC,
MEET.SSRMEET_END_DATE AS FIN_NRC,
CASE 
    WHEN MEET.SSRMEET_BEGIN_TIME IS NOT NULL 
    THEN SUBSTR(MEET.SSRMEET_BEGIN_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_BEGIN_TIME,3,2) ELSE NULL 
END AS HORA_INICIO_NRC,
CASE 
    WHEN MEET.SSRMEET_END_TIME IS NOT NULL
    THEN SUBSTR(MEET.SSRMEET_END_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_END_TIME,3,2) ELSE NULL 
END AS HORA_FIN_NRC,
CASE                    
    WHEN MEET.SSRMEET_WED_DAY = 'W' THEN 'MIERCOLES'      
    WHEN MEET.SSRMEET_WED_DAY = 'X' THEN 'MIERCOLES'     
END AS DIA,
MEET.SSRMEET_HRS_WEEK AS HORAS_SEMANALES_NRC,
CT.SSBSECT_PTRM_WEEKS * MEET.SSRMEET_HRS_WEEK AS HORAS_SEMESTRE,
T1.HR_LOW AS CREDITOS_MATERIA_NRC,--SSBSECT_CREDIT_HRS -- SSRMEET_CREDIT_HR_SESS 
T1.LEC_HR_LOW AS INTENSIDAD_HORARIA,
MEET.SSRMEET_MTYP_CODE AS TIPO_CLASE_NRC,
MEET.SSRMEET_BLDG_CODE AS BLOQUE_NRC,
MEET.SSRMEET_ROOM_CODE AS SALON_NRC,
DEF.SLBRDEF_CAPACITY AS CAPACIDAD_SALON,                
CT.SSBSECT_PTRM_CODE,  
CT.SSBSECT_MAX_ENRL,  
CT.SSBSECT_ENRL,    
CT.SSBSECT_SEATS_AVAIL,                          
SPRI.SPRIDEN_ID AS ID_DOCENTE,
SPRI.SPRIDEN_LAST_NAME AS Apellido_Docente,
SPRI.SPRIDEN_FIRST_NAME AS Nombre_Docente,
GOBTPAC_EXTERNAL_USER AS USUARIO_DOCENTE,
CASE 
    WHEN DOCENTE.SIRASGN_PRIMARY_IND = 'Y' 
    THEN 'SI' ELSE 'NO' 
END INDICADOR_PRINCIPAL,
NUMERO_ESTUDIANTES.NUMERO_ESTUDIANTES,
SLRRDEF.SLRRDEF_RDEF_CODE AS TIPO_SALON,                 
SOBPTRM_START_DATE AS FECHA_INICIO, 
SOBPTRM_END_DATE AS FECHA_FIN,
SPBPERS_SSN AS DOCUMEN_PROFESOR
FROM SSBSECT CT 
LEFT JOIN (SELECT 
           SE1.SCBCRSE_SUBJ_CODE AS SUBJ, 
           SE1.SCBCRSE_CRSE_NUMB AS CRSE,
           SE1.SCBCRSE_CREDIT_HR_LOW AS HR_LOW,
           SE1.SCBCRSE_LEC_HR_LOW AS LEC_HR_LOW,
           SE1.SCBCRSE_TITLE AS SCBCRSE_TITLE,
           SE1.SCBCRSE_COLL_CODE AS SCBCRSE_COLL_CODE,
           SE1.SCBCRSE_DEPT_CODE AS SCBCRSE_DEPT_CODE
           FROM SCBCRSE SE1 
           WHERE SE1.SCBCRSE_SURROGATE_ID= (SELECT MAX(SE2.SCBCRSE_SURROGATE_ID) 
                                            FROM SCBCRSE SE2 
                                            WHERE SE1.SCBCRSE_SUBJ_CODE||SE1.SCBCRSE_CRSE_NUMB = SE2.SCBCRSE_SUBJ_CODE||SE2.SCBCRSE_CRSE_NUMB)) T1 ON t1.subj = CT.SSBSECT_SUBJ_CODE AND T1.CRSE = CT.SSBSECT_CRSE_NUMB
LEFT JOIN STVCOLL COLL ON COLL.STVCOLL_CODE = T1.SCBCRSE_COLL_CODE
LEFT OUTER JOIN SIRASGN DOCENTE ON DOCENTE.SIRASGN_TERM_CODE = CT.SSBSECT_TERM_CODE AND DOCENTE.SIRASGN_CRN = CT.SSBSECT_CRN
LEFT OUTER JOIN SPRIDEN SPRI ON SPRI.SPRIDEN_PIDM = SIRASGN_PIDM
LEFT JOIN STVDEPT A ON A.STVDEPT_CODE = T1.SCBCRSE_DEPT_CODE
LEFT JOIN SSRMEET MEET ON MEET.SSRMEET_TERM_CODE = CT.SSBSECT_TERM_CODE AND MEET.SSRMEET_CRN = CT.SSBSECT_CRN
LEFT JOIN SSRATTR TTR ON TTR.SSRATTR_TERM_CODE = MEET.SSRMEET_TERM_CODE AND TTR.SSRATTR_CRN = MEET.SSRMEET_CRN
LEFT JOIN SLBRDEF DEF ON DEF.SLBRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND DEF.SLBRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE AND SLBRDEF_RMST_CODE = 'AC'
LEFT JOIN NUMERO_ESTUDIANTES ON TERM_CODE = MEET.SSRMEET_TERM_CODE  AND NRC = MEET.SSRMEET_CRN
LEFT JOIN (SELECT LVL.SCRLEVL_SUBJ_CODE,LVL.SCRLEVL_CRSE_NUMB,LVL.SCRLEVL_LEVL_CODE 
           FROM SCRLEVL LVL 
           WHERE LVL.SCRLEVL_SURROGATE_ID = (SELECT MAX(LV.SCRLEVL_SURROGATE_ID)
                                             FROM SCRLEVL LV 
                                             WHERE LV.SCRLEVL_SUBJ_CODE =LVL.SCRLEVL_SUBJ_CODE 
                                             AND LV.SCRLEVL_CRSE_NUMB = LVL.SCRLEVL_CRSE_NUMB)) L1 ON L1.SCRLEVL_SUBJ_CODE=CT.SSBSECT_SUBJ_CODE AND L1.SCRLEVL_CRSE_NUMB=CT.SSBSECT_CRSE_NUMB 
LEFT JOIN GOBTPAC ON GOBTPAC_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN SPBPERS ON SPBPERS_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN (SELECT
           SLRRDEF_BLDG_CODE, 
           SLRRDEF_ROOM_NUMBER, 
           SLRRDEF_RDEF_CODE
           FROM SLRRDEF SL
           WHERE SLRRDEF_SURROGATE_ID = (SELECT MAX(SLRRDEF_SURROGATE_ID) 
                                         FROM SLRRDEF  SL1
                                         WHERE SL.SLRRDEF_BLDG_CODE = SL1.SLRRDEF_BLDG_CODE
                                         AND SL.SLRRDEF_ROOM_NUMBER = SL1.SLRRDEF_ROOM_NUMBER)) SLRRDEF ON SLRRDEF.SLRRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND SLRRDEF.SLRRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE 
LEFT JOIN SOBPTRM ON SOBPTRM_TERM_CODE=CT.SSBSECT_TERM_CODE AND SOBPTRM_PTRM_CODE = CT.SSBSECT_PTRM_CODE
WHERE CT.SSBSECT_TERM_CODE >='202460' 
AND CT.SSBSECT_TERM_CODE <='9999' 
AND SPRIDEN_CHANGE_IND is null  
AND (SSRMEET_WED_DAY = 'W' OR SSRMEET_WED_DAY = 'X'))

UNION 
SELECT * FROM (
WITH NUMERO_ESTUDIANTES AS (SELECT SFRSTCR_TERM_CODE TERM_CODE, SFRSTCR_CRN NRC, COUNT(SFRSTCR_PIDM) NUMERO_ESTUDIANTES FROM SFRSTCR WHERE SFRSTCR_RSTS_CODE IN('RM','RE','RW','MF','MA') GROUP BY SFRSTCR_TERM_CODE, SFRSTCR_CRN)

SELECT 
SUBSTR(CT.SSBSECT_TERM_CODE,1,4) AS ANIO,
CT.SSBSECT_TERM_CODE AS PERIODO_CODIGO,
CT.SSBSECT_SUBJ_CODE,
SSBSECT_CRSE_NUMB,
CASE 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 10 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 60 THEN '2'
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 30 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 80 THEN '2' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 00 THEN '3' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 50 THEN '4' 
    ELSE NULL 
END AS SEMESTRE,
CT.SSBSECT_CRN AS NRC,
CT.SSBSECT_SSTS_CODE AS STATUS_NRC,
CT.SSBSECT_CAMP_CODE AS CIUDAD_CODIGO_NRC,
CASE 
     WHEN CT.SSBSECT_CAMP_CODE = 'VIR' 
     THEN 'VIRTUAL' ELSE 'PRESENCIAL' 
END AS MODALIDAD_NRC,
CASE 
     WHEN CT.SSBSECT_SESS_CODE = 'V' THEN 'VIRTUAL'
     WHEN CT.SSBSECT_SESS_CODE = 'D' THEN 'DIURNO'
     WHEN CT.SSBSECT_SESS_CODE = 'N' THEN 'NOCTURNO'
     ELSE CT.SSBSECT_SESS_CODE 
END AS JORNADA_NRC,
--TTR.SSRATTR_ATTR_CODE AS ATRIBUTO_NRC,
CT.SSBSECT_SUBJ_CODE||CT.SSBSECT_CRSE_NUMB AS CODIGO_MATERIA_NRC,
T1.SCBCRSE_TITLE AS NOMBRE_MATERIA_NRC,                 
L1.SCRLEVL_LEVL_CODE AS NIVEL_MATERIA,
COLL.STVCOLL_DESC AS FACULTAD_MATERIA,
A.STVDEPT_DESC AS ESCUELA_PROFESOR,
MEET.SSRMEET_START_DATE AS INICIO_NRC,
MEET.SSRMEET_END_DATE AS FIN_NRC,
CASE 
    WHEN MEET.SSRMEET_BEGIN_TIME IS NOT NULL 
    THEN SUBSTR(MEET.SSRMEET_BEGIN_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_BEGIN_TIME,3,2) ELSE NULL 
END AS HORA_INICIO_NRC,
CASE 
    WHEN MEET.SSRMEET_END_TIME IS NOT NULL
    THEN SUBSTR(MEET.SSRMEET_END_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_END_TIME,3,2) ELSE NULL 
END AS HORA_FIN_NRC,
CASE                    
    WHEN MEET.SSRMEET_TUE_DAY = 'T' THEN 'MARTES'  
    WHEN MEET.SSRMEET_TUE_DAY = 'M' THEN 'MARTES' 
END AS DIA,
MEET.SSRMEET_HRS_WEEK AS HORAS_SEMANALES_NRC,
CT.SSBSECT_PTRM_WEEKS * MEET.SSRMEET_HRS_WEEK AS HORAS_SEMESTRE,
T1.HR_LOW AS CREDITOS_MATERIA_NRC,--SSBSECT_CREDIT_HRS -- SSRMEET_CREDIT_HR_SESS 
T1.LEC_HR_LOW AS INTENSIDAD_HORARIA,
MEET.SSRMEET_MTYP_CODE AS TIPO_CLASE_NRC,
MEET.SSRMEET_BLDG_CODE AS BLOQUE_NRC,
MEET.SSRMEET_ROOM_CODE AS SALON_NRC,
DEF.SLBRDEF_CAPACITY AS CAPACIDAD_SALON,
CT.SSBSECT_PTRM_CODE,  
CT.SSBSECT_MAX_ENRL,  
CT.SSBSECT_ENRL,    
CT.SSBSECT_SEATS_AVAIL,                          
SPRI.SPRIDEN_ID AS ID_DOCENTE,
SPRI.SPRIDEN_LAST_NAME AS Apellido_Docente,
SPRI.SPRIDEN_FIRST_NAME AS Nombre_Docente,
GOBTPAC_EXTERNAL_USER AS USUARIO_DOCENTE,
CASE 
    WHEN DOCENTE.SIRASGN_PRIMARY_IND = 'Y' 
    THEN 'SI' ELSE 'NO' 
END INDICADOR_PRINCIPAL,
NUMERO_ESTUDIANTES.NUMERO_ESTUDIANTES,
SLRRDEF.SLRRDEF_RDEF_CODE AS TIPO_SALON,                 
SOBPTRM_START_DATE AS FECHA_INICIO, 
SOBPTRM_END_DATE AS FECHA_FIN,
SPBPERS_SSN AS DOCUMEN_PROFESOR
FROM SSBSECT CT 
LEFT JOIN (SELECT 
           SE1.SCBCRSE_SUBJ_CODE AS SUBJ, 
           SE1.SCBCRSE_CRSE_NUMB AS CRSE,
           SE1.SCBCRSE_CREDIT_HR_LOW AS HR_LOW,
           SE1.SCBCRSE_LEC_HR_LOW AS LEC_HR_LOW,
           SE1.SCBCRSE_TITLE AS SCBCRSE_TITLE,
           SE1.SCBCRSE_COLL_CODE AS SCBCRSE_COLL_CODE,
           SE1.SCBCRSE_DEPT_CODE AS SCBCRSE_DEPT_CODE
           FROM SCBCRSE SE1 
           WHERE SE1.SCBCRSE_SURROGATE_ID= (SELECT MAX(SE2.SCBCRSE_SURROGATE_ID) 
                                            FROM SCBCRSE SE2 
                                            WHERE SE1.SCBCRSE_SUBJ_CODE||SE1.SCBCRSE_CRSE_NUMB = SE2.SCBCRSE_SUBJ_CODE||SE2.SCBCRSE_CRSE_NUMB)) T1 ON t1.subj = CT.SSBSECT_SUBJ_CODE AND T1.CRSE = CT.SSBSECT_CRSE_NUMB
LEFT JOIN STVCOLL COLL ON COLL.STVCOLL_CODE = T1.SCBCRSE_COLL_CODE
LEFT OUTER JOIN SIRASGN DOCENTE ON DOCENTE.SIRASGN_TERM_CODE = CT.SSBSECT_TERM_CODE AND DOCENTE.SIRASGN_CRN = CT.SSBSECT_CRN
LEFT OUTER JOIN SPRIDEN SPRI ON SPRI.SPRIDEN_PIDM = SIRASGN_PIDM
LEFT JOIN STVDEPT A ON A.STVDEPT_CODE = T1.SCBCRSE_DEPT_CODE
LEFT JOIN SSRMEET MEET ON MEET.SSRMEET_TERM_CODE = CT.SSBSECT_TERM_CODE AND MEET.SSRMEET_CRN = CT.SSBSECT_CRN
LEFT JOIN SSRATTR TTR ON TTR.SSRATTR_TERM_CODE = MEET.SSRMEET_TERM_CODE AND TTR.SSRATTR_CRN = MEET.SSRMEET_CRN
LEFT JOIN SLBRDEF DEF ON DEF.SLBRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND DEF.SLBRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE AND SLBRDEF_RMST_CODE = 'AC'
LEFT JOIN NUMERO_ESTUDIANTES ON TERM_CODE = MEET.SSRMEET_TERM_CODE  AND NRC = MEET.SSRMEET_CRN
LEFT JOIN (SELECT LVL.SCRLEVL_SUBJ_CODE,LVL.SCRLEVL_CRSE_NUMB,LVL.SCRLEVL_LEVL_CODE 
           FROM SCRLEVL LVL 
           WHERE LVL.SCRLEVL_SURROGATE_ID = (SELECT MAX(LV.SCRLEVL_SURROGATE_ID)
                                             FROM SCRLEVL LV 
                                             WHERE LV.SCRLEVL_SUBJ_CODE =LVL.SCRLEVL_SUBJ_CODE 
                                             AND LV.SCRLEVL_CRSE_NUMB = LVL.SCRLEVL_CRSE_NUMB)) L1 ON L1.SCRLEVL_SUBJ_CODE=CT.SSBSECT_SUBJ_CODE AND L1.SCRLEVL_CRSE_NUMB=CT.SSBSECT_CRSE_NUMB 
LEFT JOIN GOBTPAC ON GOBTPAC_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN SPBPERS ON SPBPERS_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN (SELECT
           SLRRDEF_BLDG_CODE, 
           SLRRDEF_ROOM_NUMBER, 
           SLRRDEF_RDEF_CODE
           FROM SLRRDEF SL
           WHERE SLRRDEF_SURROGATE_ID = (SELECT MAX(SLRRDEF_SURROGATE_ID) 
                                         FROM SLRRDEF  SL1
                                         WHERE SL.SLRRDEF_BLDG_CODE = SL1.SLRRDEF_BLDG_CODE
                                         AND SL.SLRRDEF_ROOM_NUMBER = SL1.SLRRDEF_ROOM_NUMBER)) SLRRDEF ON SLRRDEF.SLRRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND SLRRDEF.SLRRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE 
LEFT JOIN SOBPTRM ON SOBPTRM_TERM_CODE=CT.SSBSECT_TERM_CODE AND SOBPTRM_PTRM_CODE = CT.SSBSECT_PTRM_CODE
WHERE CT.SSBSECT_TERM_CODE >='202460' 
AND CT.SSBSECT_TERM_CODE <='9999' 
AND SPRIDEN_CHANGE_IND is null  
AND (SSRMEET_TUE_DAY = 'T' OR SSRMEET_TUE_DAY = 'M'))

UNION
SELECT * FROM (
WITH NUMERO_ESTUDIANTES AS (SELECT SFRSTCR_TERM_CODE TERM_CODE, SFRSTCR_CRN NRC, COUNT(SFRSTCR_PIDM) NUMERO_ESTUDIANTES FROM SFRSTCR WHERE SFRSTCR_RSTS_CODE IN('RM','RE','RW','MF','MA') GROUP BY SFRSTCR_TERM_CODE, SFRSTCR_CRN)

SELECT 
SUBSTR(CT.SSBSECT_TERM_CODE,1,4) AS ANIO,
CT.SSBSECT_TERM_CODE AS PERIODO_CODIGO,
CT.SSBSECT_SUBJ_CODE,
SSBSECT_CRSE_NUMB,
CASE 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 10 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 60 THEN '2'
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 30 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 80 THEN '2' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 00 THEN '3' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 50 THEN '4' 
    ELSE NULL 
END AS SEMESTRE,
CT.SSBSECT_CRN AS NRC,
CT.SSBSECT_SSTS_CODE AS STATUS_NRC,
CT.SSBSECT_CAMP_CODE AS CIUDAD_CODIGO_NRC,
CASE 
    WHEN CT.SSBSECT_CAMP_CODE = 'VIR' 
    THEN 'VIRTUAL' ELSE 'PRESENCIAL' 
END AS MODALIDAD_NRC,
CASE 
    WHEN CT.SSBSECT_SESS_CODE = 'V' THEN 'VIRTUAL'
    WHEN CT.SSBSECT_SESS_CODE = 'D' THEN 'DIURNO'
    WHEN CT.SSBSECT_SESS_CODE = 'N' THEN 'NOCTURNO'
    ELSE CT.SSBSECT_SESS_CODE 
END AS JORNADA_NRC,
--TTR.SSRATTR_ATTR_CODE AS ATRIBUTO_NRC,
CT.SSBSECT_SUBJ_CODE||CT.SSBSECT_CRSE_NUMB AS CODIGO_MATERIA_NRC,
T1.SCBCRSE_TITLE AS NOMBRE_MATERIA_NRC,                 
L1.SCRLEVL_LEVL_CODE AS NIVEL_MATERIA,
COLL.STVCOLL_DESC AS FACULTAD_MATERIA,
A.STVDEPT_DESC AS ESCUELA_PROFESOR,
MEET.SSRMEET_START_DATE AS INICIO_NRC,
MEET.SSRMEET_END_DATE AS FIN_NRC,
CASE 
    WHEN MEET.SSRMEET_BEGIN_TIME IS NOT NULL 
    THEN SUBSTR(MEET.SSRMEET_BEGIN_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_BEGIN_TIME,3,2) ELSE NULL 
END AS HORA_INICIO_NRC,
CASE 
    WHEN MEET.SSRMEET_END_TIME IS NOT NULL
    THEN SUBSTR(MEET.SSRMEET_END_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_END_TIME,3,2) ELSE NULL 
END AS HORA_FIN_NRC,
CASE                    
    WHEN MEET.SSRMEET_SAT_DAY = 'S' 
    THEN 'SABADO'                
END AS DIA,
MEET.SSRMEET_HRS_WEEK AS HORAS_SEMANALES_NRC,
CT.SSBSECT_PTRM_WEEKS * MEET.SSRMEET_HRS_WEEK AS HORAS_SEMESTRE,
T1.HR_LOW AS CREDITOS_MATERIA_NRC,--SSBSECT_CREDIT_HRS -- SSRMEET_CREDIT_HR_SESS 
T1.LEC_HR_LOW AS INTENSIDAD_HORARIA,
MEET.SSRMEET_MTYP_CODE AS TIPO_CLASE_NRC,
MEET.SSRMEET_BLDG_CODE AS BLOQUE_NRC,
MEET.SSRMEET_ROOM_CODE AS SALON_NRC,
DEF.SLBRDEF_CAPACITY AS CAPACIDAD_SALON,
CT.SSBSECT_PTRM_CODE,  
CT.SSBSECT_MAX_ENRL,  
CT.SSBSECT_ENRL,    
CT.SSBSECT_SEATS_AVAIL,                          
SPRI.SPRIDEN_ID AS ID_DOCENTE,
SPRI.SPRIDEN_LAST_NAME AS Apellido_Docente,
SPRI.SPRIDEN_FIRST_NAME AS Nombre_Docente,
GOBTPAC_EXTERNAL_USER AS USUARIO_DOCENTE,
CASE 
    WHEN DOCENTE.SIRASGN_PRIMARY_IND = 'Y' 
    THEN 'SI' ELSE 'NO' 
END INDICADOR_PRINCIPAL,
NUMERO_ESTUDIANTES.NUMERO_ESTUDIANTES,
SLRRDEF.SLRRDEF_RDEF_CODE AS TIPO_SALON,                 
SOBPTRM_START_DATE AS FECHA_INICIO, 
SOBPTRM_END_DATE AS FECHA_FIN,
SPBPERS_SSN AS DOCUMEN_PROFESOR
FROM SSBSECT CT 
LEFT JOIN (SELECT 
           SE1.SCBCRSE_SUBJ_CODE AS SUBJ, 
           SE1.SCBCRSE_CRSE_NUMB AS CRSE,
           SE1.SCBCRSE_CREDIT_HR_LOW AS HR_LOW,
           SE1.SCBCRSE_LEC_HR_LOW AS LEC_HR_LOW,
           SE1.SCBCRSE_TITLE AS SCBCRSE_TITLE,
           SE1.SCBCRSE_COLL_CODE AS SCBCRSE_COLL_CODE,
           SE1.SCBCRSE_DEPT_CODE AS SCBCRSE_DEPT_CODE
           FROM SCBCRSE SE1 
           WHERE SE1.SCBCRSE_SURROGATE_ID= (SELECT MAX(SE2.SCBCRSE_SURROGATE_ID) 
                                            FROM SCBCRSE SE2 
                                            WHERE SE1.SCBCRSE_SUBJ_CODE||SE1.SCBCRSE_CRSE_NUMB = SE2.SCBCRSE_SUBJ_CODE||SE2.SCBCRSE_CRSE_NUMB)) T1 ON t1.subj = CT.SSBSECT_SUBJ_CODE AND T1.CRSE = CT.SSBSECT_CRSE_NUMB
LEFT JOIN STVCOLL COLL ON COLL.STVCOLL_CODE = T1.SCBCRSE_COLL_CODE
LEFT OUTER JOIN SIRASGN DOCENTE ON DOCENTE.SIRASGN_TERM_CODE = CT.SSBSECT_TERM_CODE AND DOCENTE.SIRASGN_CRN = CT.SSBSECT_CRN
LEFT OUTER JOIN SPRIDEN SPRI ON SPRI.SPRIDEN_PIDM = SIRASGN_PIDM
LEFT JOIN STVDEPT A ON A.STVDEPT_CODE = T1.SCBCRSE_DEPT_CODE
LEFT JOIN SSRMEET MEET ON MEET.SSRMEET_TERM_CODE = CT.SSBSECT_TERM_CODE AND MEET.SSRMEET_CRN = CT.SSBSECT_CRN
LEFT JOIN SSRATTR TTR ON TTR.SSRATTR_TERM_CODE = MEET.SSRMEET_TERM_CODE AND TTR.SSRATTR_CRN = MEET.SSRMEET_CRN
LEFT JOIN SLBRDEF DEF ON DEF.SLBRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND DEF.SLBRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE AND SLBRDEF_RMST_CODE = 'AC'
LEFT JOIN NUMERO_ESTUDIANTES ON TERM_CODE = MEET.SSRMEET_TERM_CODE  AND NRC = MEET.SSRMEET_CRN
LEFT JOIN (SELECT LVL.SCRLEVL_SUBJ_CODE,LVL.SCRLEVL_CRSE_NUMB,LVL.SCRLEVL_LEVL_CODE 
           FROM SCRLEVL LVL 
           WHERE LVL.SCRLEVL_SURROGATE_ID = (SELECT MAX(LV.SCRLEVL_SURROGATE_ID)
                                             FROM SCRLEVL LV 
                                             WHERE LV.SCRLEVL_SUBJ_CODE =LVL.SCRLEVL_SUBJ_CODE 
                                             AND LV.SCRLEVL_CRSE_NUMB = LVL.SCRLEVL_CRSE_NUMB)) L1 ON L1.SCRLEVL_SUBJ_CODE=CT.SSBSECT_SUBJ_CODE AND L1.SCRLEVL_CRSE_NUMB=CT.SSBSECT_CRSE_NUMB 
LEFT JOIN GOBTPAC ON GOBTPAC_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN SPBPERS ON SPBPERS_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN (SELECT
           SLRRDEF_BLDG_CODE, 
           SLRRDEF_ROOM_NUMBER, 
           SLRRDEF_RDEF_CODE
           FROM SLRRDEF SL
           WHERE SLRRDEF_SURROGATE_ID = (SELECT MAX(SLRRDEF_SURROGATE_ID) 
                                         FROM SLRRDEF  SL1
                                         WHERE SL.SLRRDEF_BLDG_CODE = SL1.SLRRDEF_BLDG_CODE
                                         AND SL.SLRRDEF_ROOM_NUMBER = SL1.SLRRDEF_ROOM_NUMBER)) SLRRDEF ON SLRRDEF.SLRRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND SLRRDEF.SLRRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE 
LEFT JOIN SOBPTRM ON SOBPTRM_TERM_CODE=CT.SSBSECT_TERM_CODE AND SOBPTRM_PTRM_CODE = CT.SSBSECT_PTRM_CODE
WHERE CT.SSBSECT_TERM_CODE >='202460' 
AND CT.SSBSECT_TERM_CODE <='9999' 
AND SPRIDEN_CHANGE_IND is null  
AND SSRMEET_SAT_DAY = 'S')

UNION 
SELECT * FROM (
WITH NUMERO_ESTUDIANTES AS (SELECT SFRSTCR_TERM_CODE TERM_CODE, SFRSTCR_CRN NRC, COUNT(SFRSTCR_PIDM) NUMERO_ESTUDIANTES FROM SFRSTCR WHERE SFRSTCR_RSTS_CODE IN('RM','RE','RW','MF','MA') GROUP BY SFRSTCR_TERM_CODE, SFRSTCR_CRN)

SELECT 
SUBSTR(CT.SSBSECT_TERM_CODE,1,4) AS ANIO,
CT.SSBSECT_TERM_CODE AS PERIODO_CODIGO,
CT.SSBSECT_SUBJ_CODE,
SSBSECT_CRSE_NUMB,
CASE 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 10 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 60 THEN '2'
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 30 THEN '1' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 80 THEN '2' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 00 THEN '3' 
    WHEN SUBSTR(CT.SSBSECT_TERM_CODE,5,2) = 50 THEN '4' 
    ELSE NULL 
END AS SEMESTRE,
CT.SSBSECT_CRN AS NRC,
CT.SSBSECT_SSTS_CODE AS STATUS_NRC,
CT.SSBSECT_CAMP_CODE AS CIUDAD_CODIGO_NRC,
CASE
    WHEN CT.SSBSECT_CAMP_CODE = 'VIR' 
    THEN 'VIRTUAL' ELSE 'PRESENCIAL' 
END AS MODALIDAD_NRC,
CASE 
    WHEN CT.SSBSECT_SESS_CODE = 'V' THEN 'VIRTUAL'
    WHEN CT.SSBSECT_SESS_CODE = 'D' THEN 'DIURNO'
    WHEN CT.SSBSECT_SESS_CODE = 'N' THEN 'NOCTURNO'
    ELSE CT.SSBSECT_SESS_CODE 
END AS JORNADA_NRC,
-- TTR.SSRATTR_ATTR_CODE AS ATRIBUTO_NRC,
CT.SSBSECT_SUBJ_CODE||CT.SSBSECT_CRSE_NUMB AS CODIGO_MATERIA_NRC,
T1.SCBCRSE_TITLE AS NOMBRE_MATERIA_NRC,                 
L1.SCRLEVL_LEVL_CODE AS NIVEL_MATERIA,
COLL.STVCOLL_DESC AS FACULTAD_MATERIA,
A.STVDEPT_DESC AS ESCUELA_PROFESOR,
MEET.SSRMEET_START_DATE AS INICIO_NRC,
MEET.SSRMEET_END_DATE AS FIN_NRC,
CASE 
    WHEN MEET.SSRMEET_BEGIN_TIME IS NOT NULL 
    THEN SUBSTR(MEET.SSRMEET_BEGIN_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_BEGIN_TIME,3,2) ELSE NULL 
END AS HORA_INICIO_NRC,
CASE 
    WHEN MEET.SSRMEET_END_TIME IS NOT NULL
    THEN SUBSTR(MEET.SSRMEET_END_TIME,1,2)||':'||SUBSTR(MEET.SSRMEET_END_TIME,3,2) ELSE NULL 
END AS HORA_FIN_NRC,
CASE 
    WHEN SSRMEET_FRI_DAY = 'F' 
    THEN 'VIERNES'                    
END AS DIA,
MEET.SSRMEET_HRS_WEEK AS HORAS_SEMANALES_NRC,
CT.SSBSECT_PTRM_WEEKS * MEET.SSRMEET_HRS_WEEK AS HORAS_SEMESTRE,
T1.HR_LOW AS CREDITOS_MATERIA_NRC,--SSBSECT_CREDIT_HRS -- SSRMEET_CREDIT_HR_SESS 
T1.LEC_HR_LOW AS INTENSIDAD_HORARIA,
MEET.SSRMEET_MTYP_CODE AS TIPO_CLASE_NRC,
MEET.SSRMEET_BLDG_CODE AS BLOQUE_NRC,
MEET.SSRMEET_ROOM_CODE AS SALON_NRC,
DEF.SLBRDEF_CAPACITY AS CAPACIDAD_SALON,
CT.SSBSECT_PTRM_CODE,  
CT.SSBSECT_MAX_ENRL,  
CT.SSBSECT_ENRL,    
CT.SSBSECT_SEATS_AVAIL,                          
SPRI.SPRIDEN_ID AS ID_DOCENTE,
SPRI.SPRIDEN_LAST_NAME AS Apellido_Docente,
SPRI.SPRIDEN_FIRST_NAME AS Nombre_Docente,
GOBTPAC_EXTERNAL_USER AS USUARIO_DOCENTE,
CASE 
    WHEN DOCENTE.SIRASGN_PRIMARY_IND = 'Y' 
    THEN 'SI' ELSE 'NO' 
END INDICADOR_PRINCIPAL,
NUMERO_ESTUDIANTES.NUMERO_ESTUDIANTES,
SLRRDEF.SLRRDEF_RDEF_CODE AS TIPO_SALON,
SOBPTRM_START_DATE AS FECHA_INICIO, 
SOBPTRM_END_DATE AS FECHA_FIN,
SPBPERS_SSN AS DOCUMEN_PROFESOR
FROM SSBSECT CT 
LEFT JOIN (SELECT 
           SE1.SCBCRSE_SUBJ_CODE AS SUBJ, 
           SE1.SCBCRSE_CRSE_NUMB AS CRSE,
           SE1.SCBCRSE_CREDIT_HR_LOW AS HR_LOW,
           SE1.SCBCRSE_LEC_HR_LOW AS LEC_HR_LOW,
           SE1.SCBCRSE_TITLE AS SCBCRSE_TITLE,
           SE1.SCBCRSE_COLL_CODE AS SCBCRSE_COLL_CODE,
           SE1.SCBCRSE_DEPT_CODE AS SCBCRSE_DEPT_CODE
           FROM SCBCRSE SE1 
           WHERE SE1.SCBCRSE_SURROGATE_ID= (SELECT MAX(SE2.SCBCRSE_SURROGATE_ID) 
                                            FROM SCBCRSE SE2 
                                            WHERE SE1.SCBCRSE_SUBJ_CODE||SE1.SCBCRSE_CRSE_NUMB = SE2.SCBCRSE_SUBJ_CODE||SE2.SCBCRSE_CRSE_NUMB)) T1 ON t1.subj = CT.SSBSECT_SUBJ_CODE AND T1.CRSE = CT.SSBSECT_CRSE_NUMB
LEFT JOIN STVCOLL COLL ON COLL.STVCOLL_CODE = T1.SCBCRSE_COLL_CODE
LEFT OUTER JOIN SIRASGN DOCENTE ON DOCENTE.SIRASGN_TERM_CODE = CT.SSBSECT_TERM_CODE AND DOCENTE.SIRASGN_CRN = CT.SSBSECT_CRN
LEFT OUTER JOIN SPRIDEN SPRI ON SPRI.SPRIDEN_PIDM = SIRASGN_PIDM
LEFT JOIN STVDEPT A ON A.STVDEPT_CODE = T1.SCBCRSE_DEPT_CODE
LEFT JOIN SSRMEET MEET ON MEET.SSRMEET_TERM_CODE = CT.SSBSECT_TERM_CODE AND MEET.SSRMEET_CRN = CT.SSBSECT_CRN
LEFT JOIN SSRATTR TTR ON TTR.SSRATTR_TERM_CODE = MEET.SSRMEET_TERM_CODE AND TTR.SSRATTR_CRN = MEET.SSRMEET_CRN
LEFT JOIN SLBRDEF DEF ON DEF.SLBRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND DEF.SLBRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE AND SLBRDEF_RMST_CODE = 'AC'
LEFT JOIN NUMERO_ESTUDIANTES ON TERM_CODE = MEET.SSRMEET_TERM_CODE  AND NRC = MEET.SSRMEET_CRN
LEFT JOIN (SELECT LVL.SCRLEVL_SUBJ_CODE,LVL.SCRLEVL_CRSE_NUMB,LVL.SCRLEVL_LEVL_CODE 
           FROM SCRLEVL LVL 
           WHERE LVL.SCRLEVL_SURROGATE_ID = (SELECT MAX(LV.SCRLEVL_SURROGATE_ID)
                                             FROM SCRLEVL LV 
                                             WHERE LV.SCRLEVL_SUBJ_CODE =LVL.SCRLEVL_SUBJ_CODE 
                                             AND LV.SCRLEVL_CRSE_NUMB = LVL.SCRLEVL_CRSE_NUMB)) L1 ON L1.SCRLEVL_SUBJ_CODE=CT.SSBSECT_SUBJ_CODE AND L1.SCRLEVL_CRSE_NUMB=CT.SSBSECT_CRSE_NUMB 
LEFT JOIN GOBTPAC ON GOBTPAC_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN SPBPERS ON SPBPERS_PIDM = SPRI.SPRIDEN_PIDM 
LEFT JOIN (SELECT
           SLRRDEF_BLDG_CODE, 
           SLRRDEF_ROOM_NUMBER, 
           SLRRDEF_RDEF_CODE
           FROM SLRRDEF SL
           WHERE SLRRDEF_SURROGATE_ID = (SELECT MAX(SLRRDEF_SURROGATE_ID) 
                                         FROM SLRRDEF  SL1
                                         WHERE SL.SLRRDEF_BLDG_CODE = SL1.SLRRDEF_BLDG_CODE
                                         AND SL.SLRRDEF_ROOM_NUMBER = SL1.SLRRDEF_ROOM_NUMBER)) SLRRDEF ON SLRRDEF.SLRRDEF_BLDG_CODE = MEET.SSRMEET_BLDG_CODE AND SLRRDEF.SLRRDEF_ROOM_NUMBER = MEET.SSRMEET_ROOM_CODE 
LEFT JOIN SOBPTRM ON SOBPTRM_TERM_CODE=CT.SSBSECT_TERM_CODE AND SOBPTRM_PTRM_CODE = CT.SSBSECT_PTRM_CODE
WHERE CT.SSBSECT_TERM_CODE >='202460'
AND CT.SSBSECT_TERM_CODE <='9999' 
AND SPRIDEN_CHANGE_IND IS NULL 
AND MEET.SSRMEET_MON_DAY IS NULL 
AND MEET.SSRMEET_TUE_DAY IS NULL 
AND MEET.SSRMEET_WED_DAY IS NULL 
AND MEET.SSRMEET_THU_DAY IS NULL
AND MEET.SSRMEET_FRI_DAY IS NULL 
AND MEET.SSRMEET_SAT_DAY IS NULL))